<%
If Request("Stuff") = "Yes" then 
	frmHeight = Request("Height")
	frmFloors = Request("Floors")
	frmLength = Request("Length")
	frmWidth = Request("Width")
	frmDead = Request("Dead")
	frmLive = Request("Live")
	frmImport = Request("Import")
	frmStructure = Request("Stucture")
	frmZone = Request("Zone")
	frmSoil = Request("Soil")
Select Case frmStructure
	Case "SMRF"
		frmRw = 12
		frmCt = .0035
	Case "CMRF"
		frmRw = 12
		frmCt = .0030
	Case "SHER"
		frmRw = 8
		frmCt = .0020
	Case "WOOD"
		frmRw = 6
		frmCt = .0020
End Select
frmPeriod = (frmCt)*((frmHeight)^(.75))
frmCcoef = (1.25*frmSoil)/(frmPeriod^(2/3))
If frmCcoef > 2.75 then frmCcoef = 2.75
frmMass = frmFloors*((1.7*frmLive*frmWidth*frmLength) + (1.4*frmDead*frmWidth*frmLength))
frmBaseShear = (((frmZone * frmImport * frmCcoef)/(frmRw))*frmMass)/1000
%>
<HTML>
<HEAD>
<TITLE>Your Results</TITLE>
</HEAD>
<BODY>
<H2>The results of your building</H2>
<P>Based on the information that you provided us, the total design base shear for your building is: <%= frmBaseShear %> Kips (1000 pounds)</P>
<P>Run <A HREF="seismic.asp">Another</A> Test</P>
<TABLE>
<TR><TD>Variable</TD><TD>Value</TD></TR>
<TR><TD COLSPAN="2" BGCOLOR="Silver"><B>Given Values</B></TD></TR>
<TR><TD>Building Floor-to-Floor Height</TD><TD><%= frmHeight %> feet</TD></TR>
<TR><TD>Number of Floors</TD><TD><%= frmFloors %></TD></TR>
<TR><TD>Building Width</TD><TD><%= frmWidth %> feet</TD></TR>
<TR><TD>Building Length</TD><TD><%= frmLength %> feet</TD></TR>
<TR><TD>Dead Load</TD><TD><%= frmDead %> psf</TD></TR>
<TR><TD>Live Load</TD><TD><%= frmLive %> psf</TD></TR>
<TR><TD>Importance Factor</TD><TD><%= frmImport %></TD></TR>
<TR><TD>Structural Factor</TD><TD><%= frmStructure %></TD></TR>
<TR><TD>Zone Factor</TD><TD><%= frmZone %></TD></TR>
<TR><TD>Soil Factor</TD><TD><%= frmSoil %></TD></TR>
<TR><TD COLSPAN="2" BGCOLOR="Silver"><B>Derived Values</B></TD></TR>
<TR><TD>Structural Factor (Rw)</TD><TD><%= frmRw %></TD></TR>
<TR><TD>Structural Factor (Ct)</TD><TD><%= frmCt %></TD></TR>
<TR><TD>Building Mass</TD><TD><%= frmMass %></TD></TR>
<TR><TD>Building Period</TD><TD><%= frmPeriod %></TD></TR>
<TR><TD>C-Coefficent</TD><TD><%= frmCcoef %></TD></TR>
<TR><TD>Design Base Shear</TD><TD><%= frmBaseShear %> Kips (1000 pounds)</TD></TR>
</TABLE>
<BR>

<FONT SIZE="+1">Seismic Loading Per Floor</FONT>
<TABLE CELLSPACING="5">
<% If frmPeriod < .7 then
	frmWhip = FALSE 
	frmFiCoef = frmBaseShear %>
<TR><TD COLSPAN="4">No Whipping Effect Predicted</TD></TR>
<% Else
	frmWhip = TRUE 
	frmFiCoef = .07*frmBaseShear*frmPeriod%>
<TR><TD COLSPAN="4"><FONT COLOR="Maroon"><B>Whipping Effect Predicted</B></FONT></TD></TR>
<% End If %>
<% 	For K = 1 to frmFloors
	frmLowerFi = frmLowerFi + (((1.7*frmLive*frmWidth*frmLength) + (1.4*frmDead*frmWidth*frmLength))/1000)*K*frmHeight
	Next %>
<TR><TD>Floor #</TD><TD>Weight</TD><TD>Height</TD><TD>Force at Floor</TD></TR>
<%	For I = 1 to frmFloors %>
<TR><TD><%= I %></TD><TD><%= ((1.7*frmLive*frmWidth*frmLength) + (1.4*frmDead*frmWidth*frmLength))/1000 %> K</TD><TD><%= I*frmHeight %> ft</TD><TD><%= Cint((((((1.7*frmLive*frmWidth*frmLength) + (1.4*frmDead*frmWidth*frmLength))/1000)*I*frmHeight)/frmLowerFi)*frmFiCoef) %> K</TD></TR>
<% Next %>
</TABLE>
<P>Run <A HREF="seismic.asp">Another</A> Test</P>
</BODY>
</HTML>
<% Else %>
	<HTML>
	<HEAD>
	<TITLE>Loading, please wait ...</TITLE>
	</HEAD>
	<BODY ONLOAD="OpenDlgPage()">
	  <H3 ALIGN="CENTER">Loading, please wait ...</H3>
	  <H4 ALIGN="CENTER">If the dialog window does not appear in the correct size, 
	  close it and then click the Foreward buton on your browser to reload the page</H4>
	</BODY>
	<SCRIPT LANGUAGE=JSCRIPT>
	function OpenDlgPage()
	{
	  strholding = showModalDialog("equakeget.htm", "MyDialog", "dialogWidth=500px;dialogHeight=295px; center=yes;border=thin;help=yes");
	  if (strholding == "")
	  {
	  history.back(1)
	  }
	  location.href = strholding;
	  event.cancelBubble = true;
	}
	</SCRIPT>
	</HTML>
<% End If %>